<?php
/*
Plugin Name: Elfsight Facebook Feed CC
Description: Make your Facebook content (Posts, Photos, Videos, Events) work on your website.
Plugin URI: https://elfsight.com/facebook-feed-widget/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=facebook-feed&utm_content=plugin-site
Version: 1.6.0
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=facebook-feed&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_facebook_feed_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_facebook_feed_config = json_decode(file_get_contents($elfsight_facebook_feed_config_path), true);

if (is_array($elfsight_facebook_feed_config['settings'])) {
    array_push($elfsight_facebook_feed_config['settings']['properties'], array(
        'id' => 'apiUrl',
        'name' => 'API URL',
        'tab' => 'more',
        'type' => 'hidden',
        'defaultValue' => get_option('elfsight-facebook-feed-cc_custom_api_url', plugin_dir_url(__FILE__) . 'api/index.php')
    ));
}

new ElfsightPlugin(array(
        'name' => 'Facebook Feed',
        'description' => 'Make your Facebook content (Posts, Photos, Videos, Events) work on your website.',
        'slug' => 'elfsight-facebook-feed',
        'version' => '1.6.0',
        'text_domain' => 'elfsight-facebook-feed',
        'editor_settings' => $elfsight_facebook_feed_config['settings'],
        'editor_preferences' => $elfsight_facebook_feed_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-facebook-feed.js', __FILE__),

        'plugin_name' => 'Elfsight Facebook Feed',
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => 'https://a.elfsight.com/updates/v1/',

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/facebook-feed-observer.js', __FILE__),

        'product_url' => 'https://codecanyon.net/item/wordpress-facebook-plugin-facebook-feed-widget/20611532?ref=Elfsight',
        'support_url' => 'https://elfsight.ticksy.com/submit/#100010703'
    )
);

?>