!function(){"use strict";
/**
	 * @preserve FastClick: polyfill to remove click delays on browsers with touch UIs.
	 *
	 * @codingstandard ftlabs-jsv2
	 * @copyright The Financial Times Limited [All Rights Reserved]
	 * @license MIT License (see LICENSE.txt)
	 */
/*jslint browser:true, node:true*/
/*global define, Event, Node*/
/**
	 * Instantiate fast-clicking listeners on the specified layer.
	 *
	 * @constructor
	 * @param {Element} layer The layer to listen on
	 * @param {Object} [options={}] The options to override the defaults
	 */function c(o,e){
// Some old versions of Android don't have Function.prototype.bind
function t(e,t){return function(){return e.apply(t,arguments)}}var n;if(e=e||{},
/**
		 * Whether a click is currently being tracked.
		 *
		 * @type boolean
		 */
this.trackingClick=!1,
/**
		 * Timestamp for when click tracking started.
		 *
		 * @type number
		 */
this.trackingClickStart=0,
/**
		 * The element being tracked for a click.
		 *
		 * @type EventTarget
		 */
this.targetElement=null,
/**
		 * X-coordinate of touch start event.
		 *
		 * @type number
		 */
this.touchStartX=0,
/**
		 * Y-coordinate of touch start event.
		 *
		 * @type number
		 */
this.touchStartY=0,
/**
		 * ID of the last touch, retrieved from Touch.identifier.
		 *
		 * @type number
		 */
this.lastTouchIdentifier=0,
/**
		 * Touchmove boundary, beyond which a click will be cancelled.
		 *
		 * @type number
		 */
this.touchBoundary=e.touchBoundary||10,
/**
		 * The FastClick layer.
		 *
		 * @type Element
		 */
this.layer=o,
/**
		 * The minimum time between tap(touchstart and touchend) events
		 *
		 * @type number
		 */
this.tapDelay=e.tapDelay||200,
/**
		 * The maximum time for a tap
		 *
		 * @type number
		 */
this.tapTimeout=e.tapTimeout||700,!c.notNeeded(o)){for(var i=["onMouse","onClick","onTouchStart","onTouchMove","onTouchEnd","onTouchCancel"],r=this,s=0,a=i.length;s<a;s++)r[i[s]]=t(r[i[s]],r);
// Set up event handlers as required
h&&(o.addEventListener("mouseover",this.onMouse,!0),o.addEventListener("mousedown",this.onMouse,!0),o.addEventListener("mouseup",this.onMouse,!0)),o.addEventListener("click",this.onClick,!0),o.addEventListener("touchstart",this.onTouchStart,!1),o.addEventListener("touchmove",this.onTouchMove,!1),o.addEventListener("touchend",this.onTouchEnd,!1),o.addEventListener("touchcancel",this.onTouchCancel,!1),
// Hack is required for browsers that don't support Event#stopImmediatePropagation (e.g. Android 2)
// which is how FastClick normally stops click events bubbling to callbacks registered on the FastClick
// layer when they are cancelled.
Event.prototype.stopImmediatePropagation||(o.removeEventListener=function(e,t,n){var i=Node.prototype.removeEventListener;"click"===e?i.call(o,e,t.hijacked||t,n):i.call(o,e,t,n)},o.addEventListener=function(e,t,n){var i=Node.prototype.addEventListener;"click"===e?i.call(o,e,t.hijacked||(t.hijacked=function(e){e.propagationStopped||t(e)}),n):i.call(o,e,t,n)}),
// If a handler is already declared in the element's onclick attribute, it will be fired before
// FastClick's onClick handler. Fix this by pulling out the user-defined handler function and
// adding it as listener.
"function"==typeof o.onclick&&(
// Android browser on at least 3.2 requires a new reference to the function in layer.onclick
// - the old one won't work if passed to addEventListener directly.
n=o.onclick,o.addEventListener("click",function(e){n(e)},!1),o.onclick=null)}}
/**
	* Windows Phone 8.1 fakes user agent string to look like Android and iPhone.
	*
	* @type boolean
	*/var e=0<=navigator.userAgent.indexOf("Windows Phone"),h=0<navigator.userAgent.indexOf("Android")&&!e,a=/iP(ad|hone|od)/.test(navigator.userAgent)&&!e,u=a&&/OS 4_\d(_\d)?/.test(navigator.userAgent),m=a&&/OS [6-7]_\d/.test(navigator.userAgent),r=0<navigator.userAgent.indexOf("BB10");
/**
	 * Android requires exceptions.
	 *
	 * @type boolean
	 */
/**
	 * Determine whether a given element requires a native click.
	 *
	 * @param {EventTarget|Element} target Target DOM element
	 * @returns {boolean} Returns true if the element needs a native click
	 */
c.prototype.needsClick=function(e){switch(e.nodeName.toLowerCase()){
// Don't send a synthetic click to disabled inputs (issue #62)
case"button":case"select":case"textarea":if(e.disabled)return!0;break;case"input":
// File inputs need real clicks on iOS 6 due to a browser bug (issue #68)
if(a&&"file"===e.type||e.disabled)return!0;break;case"label":case"iframe":// iOS8 homescreen apps can prevent events bubbling into frames
case"video":return!0}return/\bneedsclick\b/.test(e.className)},
/**
	 * Determine whether a given element requires a call to focus to simulate click into element.
	 *
	 * @param {EventTarget|Element} target Target DOM element
	 * @returns {boolean} Returns true if the element requires a call to focus to simulate native click.
	 */
c.prototype.needsFocus=function(e){switch(e.nodeName.toLowerCase()){case"textarea":return!0;case"select":return!h;case"input":switch(e.type){case"button":case"checkbox":case"file":case"image":case"radio":case"submit":return!1}
// No point in attempting to focus disabled inputs
return!e.disabled&&!e.readOnly;default:return/\bneedsfocus\b/.test(e.className)}},
/**
	 * Send a click event to the specified element.
	 *
	 * @param {EventTarget|Element} targetElement
	 * @param {Event} event
	 */
c.prototype.sendClick=function(e,t){var n,i;
// On some Android devices activeElement needs to be blurred otherwise the synthetic click will have no effect (#24)
document.activeElement&&document.activeElement!==e&&document.activeElement.blur(),i=t.changedTouches[0],(
// Synthesise a click event, with an extra attribute so it can be tracked
n=document.createEvent("MouseEvents")).initMouseEvent(this.determineEventType(e),!0,!0,window,1,i.screenX,i.screenY,i.clientX,i.clientY,!1,!1,!1,!1,0,null),n.forwardedTouchEvent=!0,e.dispatchEvent(n)},c.prototype.determineEventType=function(e){
//Issue #159: Android Chrome Select Box does not open with a synthetic click event
return h&&"select"===e.tagName.toLowerCase()?"mousedown":"click"},
/**
	 * @param {EventTarget|Element} targetElement
	 */
c.prototype.focus=function(e){var t;
// Issue #160: on iOS 7, some input elements (e.g. date datetime month) throw a vague TypeError on setSelectionRange. These elements don't have an integer value for the selectionStart and selectionEnd properties, but unfortunately that can't be used for detection because accessing the properties also throws a TypeError. Just check the type instead. Filed as Apple bug #15122724.
a&&e.setSelectionRange&&0!==e.type.indexOf("date")&&"time"!==e.type&&"month"!==e.type?(t=e.value.length,e.setSelectionRange(t,t)):e.focus()},
/**
	 * Check whether the given target element is a child of a scrollable layer and if so, set a flag on it.
	 *
	 * @param {EventTarget|Element} targetElement
	 */
c.prototype.updateScrollParent=function(e){var t,n;
// Attempt to discover whether the target element is contained within a scrollable layer. Re-check if the
// target element was moved to another parent.
if(!(t=e.fastClickScrollParent)||!t.contains(e)){n=e;do{if(n.scrollHeight>n.offsetHeight){t=n,e.fastClickScrollParent=n;break}n=n.parentElement}while(n)}
// Always update the scroll top tracker if possible.
t&&(t.fastClickLastScrollTop=t.scrollTop)},
/**
	 * @param {EventTarget} targetElement
	 * @returns {Element|EventTarget}
	 */
c.prototype.getTargetElementFromEventTarget=function(e){
// On some older browsers (notably Safari on iOS 4.1 - see issue #56) the event target may be a text node.
return e.nodeType===Node.TEXT_NODE?e.parentNode:e},
/**
	 * On touch start, record the position and scroll offset.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.onTouchStart=function(e){var t,n,i;
// Ignore multiple touches, otherwise pinch-to-zoom is prevented if both fingers are on the FastClick element (issue #111).
if(1<e.targetTouches.length)return!0;if(t=this.getTargetElementFromEventTarget(e.target),n=e.targetTouches[0],a){if((
// Only trusted events will deselect text on iOS (issue #49)
i=window.getSelection()).rangeCount&&!i.isCollapsed)return!0;if(!u){
// Weird things happen on iOS when an alert or confirm dialog is opened from a click event callback (issue #23):
// when the user next taps anywhere else on the page, new touchstart and touchend events are dispatched
// with the same identifier as the touch event that previously triggered the click that triggered the alert.
// Sadly, there is an issue on iOS 4 that causes some normal touch events to have the same identifier as an
// immediately preceeding touch event (issue #52), so this fix is unavailable on that platform.
// Issue 120: touch.identifier is 0 when Chrome dev tools 'Emulate touch events' is set with an iOS device UA string,
// which causes all touch events to be ignored. As this block only applies to iOS, and iOS identifiers are always long,
// random integers, it's safe to to continue if the identifier is 0 here.
if(n.identifier&&n.identifier===this.lastTouchIdentifier)return e.preventDefault(),!1;this.lastTouchIdentifier=n.identifier,
// If the target element is a child of a scrollable layer (using -webkit-overflow-scrolling: touch) and:
// 1) the user does a fling scroll on the scrollable layer
// 2) the user stops the fling scroll with another tap
// then the event.target of the last 'touchend' event will be the element that was under the user's finger
// when the fling scroll was started, causing FastClick to send a click event to that layer - unless a check
// is made to ensure that a parent layer was not scrolled before sending a synthetic click (issue #42).
this.updateScrollParent(t)}}return this.trackingClick=!0,this.trackingClickStart=e.timeStamp,this.targetElement=t,this.touchStartX=n.pageX,this.touchStartY=n.pageY,
// Prevent phantom clicks on fast double-tap (issue #36)
e.timeStamp-this.lastClickTime<this.tapDelay&&e.preventDefault(),!0},
/**
	 * Based on a touchmove event object, check whether the touch has moved past a boundary since it started.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.touchHasMoved=function(e){var t=e.changedTouches[0],n=this.touchBoundary;return Math.abs(t.pageX-this.touchStartX)>n||Math.abs(t.pageY-this.touchStartY)>n},
/**
	 * Update the last position.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.onTouchMove=function(e){return this.trackingClick&&(this.targetElement!==this.getTargetElementFromEventTarget(e.target)||this.touchHasMoved(e))&&(this.trackingClick=!1,this.targetElement=null),!0;
// If the touch has moved, cancel the click tracking
},
/**
	 * Attempt to find the labelled control for the given label element.
	 *
	 * @param {EventTarget|HTMLLabelElement} labelElement
	 * @returns {Element|null}
	 */
c.prototype.findControl=function(e){
// Fast path for newer browsers supporting the HTML5 control attribute
return void 0!==e.control?e.control:
// All browsers under test that support touch events also support the HTML5 htmlFor attribute
e.htmlFor?document.getElementById(e.htmlFor):e.querySelector("button, input:not([type=hidden]), keygen, meter, output, progress, select, textarea")},
/**
	 * On touch end, determine whether to send a click event at once.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.onTouchEnd=function(e){var t,n,i,o,r,s=this.targetElement;if(!this.trackingClick)return!0;
// Prevent phantom clicks on fast double-tap (issue #36)
if(e.timeStamp-this.lastClickTime<this.tapDelay)return this.cancelNextClick=!0;if(e.timeStamp-this.trackingClickStart>this.tapTimeout)return!0;
// Reset to prevent wrong click cancel on input (issue #156).
if(this.cancelNextClick=!1,this.lastClickTime=e.timeStamp,n=this.trackingClickStart,this.trackingClick=!1,this.trackingClickStart=0,
// On some iOS devices, the targetElement supplied with the event is invalid if the layer
// is performing a transition or scroll, and has to be re-detected manually. Note that
// for this to function correctly, it must be called *after* the event target is checked!
// See issue #57; also filed as rdar://13048589 .
m&&(r=e.changedTouches[0],(
// In certain cases arguments of elementFromPoint can be negative, so prevent setting targetElement to null
s=document.elementFromPoint(r.pageX-window.pageXOffset,r.pageY-window.pageYOffset)||s).fastClickScrollParent=this.targetElement.fastClickScrollParent),"label"===(i=s.tagName.toLowerCase())){if(t=this.findControl(s)){if(this.focus(s),h)return!1;s=t}}else if(this.needsFocus(s))
// Case 1: If the touch started a while ago (best guess is 100ms based on tests for issue #36) then focus will be triggered anyway. Return early and unset the target element reference so that the subsequent click will be allowed through.
// Case 2: Without this exception for input elements tapped when the document is contained in an iframe, then any inputted text won't be visible even though the value attribute is updated as the user types (issue #37).
return 100<e.timeStamp-n||a&&window.top!==window&&"input"===i?this.targetElement=null:(this.focus(s),this.sendClick(s,e),
// Select elements need the event to go through on iOS 4, otherwise the selector menu won't open.
// Also this breaks opening selects when VoiceOver is active on iOS6, iOS7 (and possibly others)
a&&"select"===i||(this.targetElement=null,e.preventDefault())),!1;return!(!a||u||
// Don't send a synthetic click event if the target element is contained within a parent layer that was scrolled
// and this tap is being used to stop the scrolling (usually initiated by a fling - issue #42).
!(o=s.fastClickScrollParent)||o.fastClickLastScrollTop===o.scrollTop)||(
// Prevent the actual click from going though - unless the target node is marked as requiring
// real clicks or if it is in the whitelist in which case only non-programmatic clicks are permitted.
this.needsClick(s)||(e.preventDefault(),this.sendClick(s,e)),!1)},
/**
	 * On touch cancel, stop tracking the click.
	 *
	 * @returns {void}
	 */
c.prototype.onTouchCancel=function(){this.trackingClick=!1,this.targetElement=null},
/**
	 * Determine mouse events which should be permitted.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.onMouse=function(e){
// If a target element was never set (because a touch event was never fired) allow the event
return!this.targetElement||(!!e.forwardedTouchEvent||(
// Programmatically generated events targeting a specific element should be permitted
!e.cancelable||(
// Derive and check the target element to see whether the mouse event needs to be permitted;
// unless explicitly enabled, prevent non-touch click events from triggering actions,
// to prevent ghost/doubleclicks.
!(!this.needsClick(this.targetElement)||this.cancelNextClick)||(
// Prevent any user-added listeners declared on FastClick element from being fired.
e.stopImmediatePropagation?e.stopImmediatePropagation():
// Part of the hack for browsers that don't support Event#stopImmediatePropagation (e.g. Android 2)
e.propagationStopped=!0,
// Cancel the event
e.stopPropagation(),e.preventDefault(),!1))))},
/**
	 * On actual clicks, determine whether this is a touch-generated click, a click action occurring
	 * naturally after a delay after a touch (which needs to be cancelled to avoid duplication), or
	 * an actual click which should be permitted.
	 *
	 * @param {Event} event
	 * @returns {boolean}
	 */
c.prototype.onClick=function(e){var t;
// It's possible for another FastClick-like library delivered with third-party code to fire a click event before FastClick does (issue #44). In that case, set the click-tracking flag back to false and return early. This will cause onTouchEnd to return early.
return this.trackingClick?(this.targetElement=null,!(this.trackingClick=!1)):
// Very odd behaviour on iOS (issue #18): if a submit element is present inside a form and the user hits enter in the iOS simulator or clicks the Go button on the pop-up OS keyboard the a kind of 'fake' click event will be triggered with the submit-type input element as the target.
"submit"===e.target.type&&0===e.detail||(
// Only unset targetElement if the click is not permitted. This will ensure that the check for !targetElement in onMouse fails and the browser's click doesn't go through.
(t=this.onMouse(e))||(this.targetElement=null),t)},
/**
	 * Remove all FastClick's event listeners.
	 *
	 * @returns {void}
	 */
c.prototype.destroy=function(){var e=this.layer;h&&(e.removeEventListener("mouseover",this.onMouse,!0),e.removeEventListener("mousedown",this.onMouse,!0),e.removeEventListener("mouseup",this.onMouse,!0)),e.removeEventListener("click",this.onClick,!0),e.removeEventListener("touchstart",this.onTouchStart,!1),e.removeEventListener("touchmove",this.onTouchMove,!1),e.removeEventListener("touchend",this.onTouchEnd,!1),e.removeEventListener("touchcancel",this.onTouchCancel,!1)},
/**
	 * Check whether FastClick is needed.
	 *
	 * @param {Element} layer The layer to listen on
	 */
c.notNeeded=function(e){var t,n,i,o;
// Devices that don't support touch don't need FastClick
if(void 0===window.ontouchstart)return!0;
// Chrome version - zero for other browsers
if(n=+(/Chrome\/([0-9]+)/.exec(navigator.userAgent)||[,0])[1]){if(!h)return!0;if(t=document.querySelector("meta[name=viewport]")){
// Chrome on Android with user-scalable="no" doesn't need FastClick (issue #89)
if(-1!==t.content.indexOf("user-scalable=no"))return!0;
// Chrome 32 and above with width=device-width or less don't need FastClick
if(31<n&&document.documentElement.scrollWidth<=window.outerWidth)return!0}
// Chrome desktop doesn't need FastClick (issue #15)
}if(r&&10<=(i=navigator.userAgent.match(/Version\/([0-9]*)\.([0-9]*)/))[1]&&3<=i[2]&&(t=document.querySelector("meta[name=viewport]"))){
// user-scalable=no eliminates click delay.
if(-1!==t.content.indexOf("user-scalable=no"))return!0;
// width=device-width (or less than device-width) eliminates click delay.
if(document.documentElement.scrollWidth<=window.outerWidth)return!0}
// IE10 with -ms-touch-action: none or manipulation, which disables double-tap-to-zoom (issue #97)
return"none"===e.style.msTouchAction||"manipulation"===e.style.touchAction||(!!(27<=(
// Firefox version - zero for other browsers
o=+(/Firefox\/([0-9]+)/.exec(navigator.userAgent)||[,0])[1])&&(
// Firefox 27+ does not have tap delay if the content is not zoomable - https://bugzilla.mozilla.org/show_bug.cgi?id=922896
t=document.querySelector("meta[name=viewport]"))&&(-1!==t.content.indexOf("user-scalable=no")||document.documentElement.scrollWidth<=window.outerWidth))||("none"===e.style.touchAction||"manipulation"===e.style.touchAction))},
/**
	 * Factory method for creating a FastClick object
	 *
	 * @param {Element} layer The layer to listen on
	 * @param {Object} [options={}] The options to override the defaults
	 */
c.attach=function(e,t){return new c(e,t)},"function"==typeof define&&"object"==typeof define.amd&&define.amd?
// AMD. Register as an anonymous module.
define(function(){return c}):"undefined"!=typeof module&&module.exports?(module.exports=c.attach,module.exports.FastClick=c):window.FastClick=c}(),function(e,t){"function"==typeof define&&define.amd?define("ev-emitter/ev-emitter",t):"object"==typeof module&&module.exports?module.exports=t():e.EvEmitter=t()}("undefined"!=typeof window?window:this,function(){function e(){}var t=e.prototype;return t.on=function(e,t){if(e&&t){var n=this._events=this._events||{},i=n[e]=n[e]||[];return-1==i.indexOf(t)&&i.push(t),this}},t.once=function(e,t){if(e&&t){this.on(e,t);var n=this._onceEvents=this._onceEvents||{},i;return(n[e]=n[e]||{})[t]=!0,this}},t.off=function(e,t){var n=this._events&&this._events[e];if(n&&n.length){var i=n.indexOf(t);return-1!=i&&n.splice(i,1),this}},t.emitEvent=function(e,t){var n=this._events&&this._events[e];if(n&&n.length){n=n.slice(0),t=t||[];for(var i=this._onceEvents&&this._onceEvents[e],o=0;o<n.length;o++){var r=n[o],s;i&&i[r]&&(this.off(e,r),delete i[r]),r.apply(this,t)}return this}},t.allOff=function(){delete this._events,delete this._onceEvents},e}),function(t,n){"use strict";"function"==typeof define&&define.amd?define(["ev-emitter/ev-emitter"],function(e){return n(t,e)}):"object"==typeof module&&module.exports?module.exports=n(t,require("ev-emitter")):t.imagesLoaded=n(t,t.EvEmitter)}("undefined"!=typeof window?window:this,function(t,e){function o(e,t){for(var n in t)e[n]=t[n];return e}function r(e){return Array.isArray(e)?e:"object"==typeof e&&"number"==typeof e.length?h.call(e):[e];var t}function s(e,t,n){if(!(this instanceof s))return new s(e,t,n);var i=e;return"string"==typeof e&&(i=document.querySelectorAll(e)),i?(this.elements=r(i),this.options=o({},this.options),"function"==typeof t?n=t:o(this.options,t),n&&this.on("always",n),this.getImages(),a&&(this.jqDeferred=new a.Deferred),void setTimeout(this.check.bind(this))):void c.error("Bad element for imagesLoaded "+(i||e))}function n(e){this.img=e}function i(e,t){this.url=e,this.element=t,this.img=new Image}var a=t.jQuery,c=t.console,h=Array.prototype.slice;s.prototype=Object.create(e.prototype),s.prototype.options={},s.prototype.getImages=function(){this.images=[],this.elements.forEach(this.addElementImages,this)},s.prototype.addElementImages=function(e){"IMG"==e.nodeName&&this.addImage(e),!0===this.options.background&&this.addElementBackgroundImages(e);var t=e.nodeType;if(t&&u[t]){for(var n=e.querySelectorAll("img"),i=0;i<n.length;i++){var o=n[i];this.addImage(o)}if("string"==typeof this.options.background){var r=e.querySelectorAll(this.options.background);for(i=0;i<r.length;i++){var s=r[i];this.addElementBackgroundImages(s)}}}};var u={1:!0,9:!0,11:!0};return s.prototype.addElementBackgroundImages=function(e){var t=getComputedStyle(e);if(t)for(var n=/url\((['"])?(.*?)\1\)/gi,i=n.exec(t.backgroundImage);null!==i;){var o=i&&i[2];o&&this.addBackground(o,e),i=n.exec(t.backgroundImage)}},s.prototype.addImage=function(e){var t=new n(e);this.images.push(t)},s.prototype.addBackground=function(e,t){var n=new i(e,t);this.images.push(n)},s.prototype.check=function(){function t(e,t,n){setTimeout(function(){i.progress(e,t,n)})}var i=this;return this.progressedCount=0,this.hasAnyBroken=!1,this.images.length?void this.images.forEach(function(e){e.once("progress",t),e.check()}):void this.complete()},s.prototype.progress=function(e,t,n){this.progressedCount++,this.hasAnyBroken=this.hasAnyBroken||!e.isLoaded,this.emitEvent("progress",[this,e,t]),this.jqDeferred&&this.jqDeferred.notify&&this.jqDeferred.notify(this,e),this.progressedCount==this.images.length&&this.complete(),this.options.debug&&c&&c.log("progress: "+n,e,t)},s.prototype.complete=function(){var e=this.hasAnyBroken?"fail":"done";if(this.isComplete=!0,this.emitEvent(e,[this]),this.emitEvent("always",[this]),this.jqDeferred){var t=this.hasAnyBroken?"reject":"resolve";this.jqDeferred[t](this)}},n.prototype=Object.create(e.prototype),n.prototype.check=function(){var e;return this.getIsImageComplete()?void this.confirm(0!==this.img.naturalWidth,"naturalWidth"):(this.proxyImage=new Image,this.proxyImage.addEventListener("load",this),this.proxyImage.addEventListener("error",this),this.img.addEventListener("load",this),this.img.addEventListener("error",this),void(this.proxyImage.src=this.img.src))},n.prototype.getIsImageComplete=function(){return this.img.complete&&this.img.naturalWidth},n.prototype.confirm=function(e,t){this.isLoaded=e,this.emitEvent("progress",[this,this.img,t])},n.prototype.handleEvent=function(e){var t="on"+e.type;this[t]&&this[t](e)},n.prototype.onload=function(){this.confirm(!0,"onload"),this.unbindEvents()},n.prototype.onerror=function(){this.confirm(!1,"onerror"),this.unbindEvents()},n.prototype.unbindEvents=function(){this.proxyImage.removeEventListener("load",this),this.proxyImage.removeEventListener("error",this),this.img.removeEventListener("load",this),this.img.removeEventListener("error",this)},i.prototype=Object.create(n.prototype),i.prototype.check=function(){var e;this.img.addEventListener("load",this),this.img.addEventListener("error",this),this.img.src=this.url,this.getIsImageComplete()&&(this.confirm(0!==this.img.naturalWidth,"naturalWidth"),this.unbindEvents())},i.prototype.unbindEvents=function(){this.img.removeEventListener("load",this),this.img.removeEventListener("error",this)},i.prototype.confirm=function(e,t){this.isLoaded=e,this.emitEvent("progress",[this,this.element,t])},s.makeJQueryPlugin=function(e){(e=e||t.jQuery)&&((a=e).fn.imagesLoaded=function(e,t){var n;return new s(this,e,t).jqDeferred.promise(a(this))})},s.makeJQueryPlugin(),s}),jQuery(function(i){function e(){var n;i("header#main-header").remove(),html.length&&!i("#et-fb-app").length&&(i("#page-container").prepend('<header id="mhmm" />'),i("#mhmm").html(html),i("body").hasClass("single")&&!i("body").hasClass("single-post")&&i("#mhmm").wrap('<div id="et-boc" />')),r=i("header#mhmm").innerHeight(),i(window).scroll(function(e){var t=i(window).scrollTop();150<t?i("body").addClass("mhmm-scrolled"):(i("body").removeClass("mhmm-scrolled"),i("body").hasClass(".sticky-top-show.mhmm-menu-active")&&window.setTimeout(function(){i("body").removeClass("mhmm-menu-active")},500)),i("body").hasClass("mhmm-sticky-bottom-scroll")&&(headerDistanceFromTop=i("#mhmm").offset().top-t,headerDistanceFromTop<=0&&(i("body").addClass("header-stuck"),n=!0),n&&t<=o-r&&(i("body").removeClass("header-stuck"),n=!1))}),
// Trigger event for after Mhmm does its thing
i(document).trigger("mhmm.loaded")}function t(){i(".et_pb_mhmm_menu.vertically-centered, .et_pb_mhmm_menu_layout.vertically-centered").each(function(){var e=i(this).parent(".et_pb_column");if(i(this).length&&"block"==i(this).css("display")){var t=e.innerHeight(),n=t;
// To handle multiple menu buttons, break out of each loop once margin is set for whichever button is showing
return e.siblings(".et_pb_column").each(function(){height=i(this).innerHeight(),height>n&&(n=height)}),menuButtonColumnMargin=(n-t)/2,e.attr("style","margin-top: "+menuButtonColumnMargin+"px !important;"),!1}e.css("marginTop","auto")}),r=i("header#mhmm").innerHeight(),i("body.mhmm-sticky-top, body.mhmm-sticky-top-hide").css("paddingTop",r+"px"),i("body.mhmm-sticky-bottom").css("paddingBottom",r+"px")}function n(){i(".et_pb_mhmm_menu .menu-button, .et_pb_mhmm_menu .menu-overlay, .et_pb_mhmm_menu .menu-button-close, .et_pb_mhmm_menu_layout .menu-button, .et_pb_mhmm_menu_layout .menu-overlay, .et_pb_mhmm_menu_layout .menu-button-close").click(function(e){e.preventDefault(),i("body").toggleClass("mhmm-menu-active"),i("li.menu-item-has-children").off("touchend"),
// Stop all megamenu videos
i("header#mhmm iframe").each(function(){var e=i(this).attr("src");i(this).attr("src",e)})}),i(".menu-overlay").parents(".et_pb_column").css("z-index","50");var e=i(".et_pb_mhmm_menu nav").attr("data-back-text");i(".et_pb_mhmm_menu nav li.menu-item-has-children").each(function(){$a=i(this).children("a").clone(),$a.prependTo(i(this).children("ul")).wrap("<li>"),i(this).children("a").on("click",function(e){e.preventDefault(),i(this).parent("li").parent("ul").addClass("translated"),i(this).next("ul").addClass("visible")}),i(this).children("ul").append('<li class="back"><a href="#">'+e+"</a></li>")}),i(".et_pb_mhmm_menu nav li.back a").click(function(e){e.preventDefault(),$back=i(this),$back.parent("li").parent("ul").parent("li").parent("ul").removeClass("translated"),window.setTimeout(function(){$back.parent("li").parent("ul").removeClass("visible")},300)}),
// Hide menu when clicking same-page anchor
i('.et_pb_mhmm_menu nav li:not(.menu-item-has-children):not(.back) a[href*="#"]').click(function(e){i("body").removeClass("mhmm-menu-active")}),
// Add WooCommerce cart item count
i(".et_pb_mhmm_menu li.mhmm-cart a, .et_pb_mhmm_inline_menu li.mhmm-cart a").each(function(){(wcCartCount=i(this).parents("nav").parent("div").data("cart-count"))?i(this).html(wcCartCount):i(this).html("")})}
// Initilize header
e(),i(".et_pb_mhmm_menu, .et_pb_mhmm_menu_layout").length&&n();var o=i(window).height(),r,s;i(window).on("resize",function(e){clearTimeout(s),s=setTimeout(function(){o=i(window).height(),t()},250)}),
// On images loaded
i("body").imagesLoaded(function(){t()})});