<?php defined( 'ABSPATH' ) or die( 'No script kiddies please!' ); ?>
<?php
/*
Plugin Name: Mhmm - Mighty Header & Menu Maker
Plugin URI:  https://besuperfly.com/
Description: Build custom header and menu layouts using Divi. Includes three new Divi modules: Hamburger Menu, Inline Menu and Layout (Mega) Menu.
Version:     1.4.5
Author:      BeSuperfly
Author URI:  https://besuperfly.com/
*/

function get_mhmm_styles() {
	return array(
		'mhmm-basic' => 'Basic',
		'mhmm-sticky-top' => 'Stick to Top',
		'mhmm-sticky-top-hide' => 'Stick to Top, Hide on Scroll',
		'mhmm-sticky-top-show' => 'Stick to Top, Show on Scroll',
		'mhmm-sticky-bottom' => 'Stick to Bottom',
		'mhmm-sticky-bottom-scroll' => 'Stick to Bottom and Scroll'
	);
}

function registered_layout_category_taxonomy( $taxonomy, $object_type, $array_taxonomy_object ) { 
	if($taxonomy == 'layout_category') {
		if(!term_exists('mhmm_headers', 'layout_category')) {
			wp_insert_term('Header Layouts', 'layout_category', array('slug' => 'mhmm_headers'));
		}
		if(!term_exists('mhmm_menus', 'layout_category')) {
			wp_insert_term('Menu Layouts', 'layout_category', array('slug' => 'mhmm_menus'));
		}
	}
};
add_action( 'registered_taxonomy', 'registered_layout_category_taxonomy', 10, 3 ); 

function mhmm_register_theme_customizer( $wp_customize ) {
	$header_options = array();
	$headers = new WP_Query(array(
		'post_type' => 'et_pb_layout',
		'tax_query' => array(
			array(
				'taxonomy' => 'layout_category',
				'field' => 'slug',
				'terms' => 'mhmm_headers'
			)
		)
	));
	if($headers->have_posts()) {
		while($headers->have_posts()) {
			$headers->the_post();
			$header_options[get_the_id()] = get_the_title();
		}
	}
	wp_reset_query(); 
	$header_options['disabled'] = 'Disabled';

	$wp_customize->add_setting('mhmm_layout');
	$wp_customize->add_control(
		'header_layout', 
		array(
			'label'    => 'Header Layout',
			'section'  => 'et_divi_header_layout',
			'settings' => 'mhmm_layout',
			'type'     => 'select',
			'choices'  => $header_options,
			'description' => 'Create header layouts <a href="' . get_admin_url(null, 'edit.php?s&post_status=all&post_type=et_pb_layout&layout_category=mhmm_headers') . '">here</a>.'
		)
	);
	$wp_customize->add_setting('mhmm_style');
	$wp_customize->add_control(
		'header_style', 
		array(
			'label'    => 'Header Style',
			'section'  => 'et_divi_header_layout',
			'settings' => 'mhmm_style',
			'type'     => 'select',
			'choices'  => get_mhmm_styles(),
			'description' => 'Choose how your layout should be displayed.'
		)
	);
}
add_action( 'customize_register', 'mhmm_register_theme_customizer' , 9999);


// Add Mhmm menus only if allowed for current user
function mhmm_add_divi_menu() {	
	if ( function_exists('et_pb_is_allowed') && et_pb_is_allowed( 'divi_library' ) ) {
		add_submenu_page( 'et_divi_options', esc_html__( 'Mhmm - Headers', 'Divi' ), esc_html__( 'Mhmm - Headers', 'Divi' ), 'manage_options', 'edit.php?s&post_status=all&post_type=et_pb_layout&layout_category=mhmm_headers' );
		add_submenu_page( 'et_divi_options', esc_html__( 'Mhmm - Mega Menus', 'Divi' ), esc_html__( 'Mhmm - Mega Menus', 'Divi' ), 'manage_options', 'edit.php?s&post_status=all&post_type=et_pb_layout&layout_category=mhmm_menus' );
	}
}
add_action('admin_menu', 'mhmm_add_divi_menu', 100);

function mhmm_meta_box_markup($object) {
    wp_nonce_field(basename(__FILE__), "mhmm-nonce"); ?>
	<p>Apply a custom header or disable the header on this specific page.</p>
	<p class="post-attributes-label-wrapper">
		<label class="post-attributes-label" for="meta-mhmm-header">Header</label>
	</p>	
	<select name="meta-mhmm-header">
		<?php
		$header_options = array();
		$headers = get_posts(array(
			'post_type' => 'et_pb_layout',
			'tax_query' => array(
				array(
					'taxonomy' => 'layout_category',
					'field' => 'slug',
					'terms' => 'mhmm_headers'
				)
			),
			'posts_per_page' => -1
		));
		foreach($headers as $header) {
			$header_options[$header->ID] = $header->post_title;
		}

		$defaults = array();
		if($mhmm_layout = get_theme_mod('mhmm_layout')) {
			if(is_numeric($mhmm_layout)) {
				$defaults['default'] = 'Default (' . get_the_title($mhmm_layout) . ')';	
			}
			else {
				$defaults['default'] = 'Default (' . ucwords($mhmm_layout) . ')';		
			}
		}
		else {
			$defaults['default'] = 'Default';
		}
		$defaults['disabled'] = 'Disabled';
		$meta_header_option_values = $defaults + $header_options;
        foreach($meta_header_option_values as $value => $text) {
            if($value == get_post_meta($object->ID, "meta-mhmm-header", true)) { ?>
                <option value="<?=$value;?>" selected><?php echo $text; ?></option>
            <?php }
            else { ?>
                <option value="<?=$value;?>" ><?php echo $text; ?></option>
			<?php }
        }
        ?>
	</select>
	<p class="post-attributes-label-wrapper">
		<label class="post-attributes-label" for="meta-mhmm-style">Style</label>
	</p>
	<?php $mhmm_styles = get_mhmm_styles(); ?>
	<?php if(get_theme_mod('mhmm_style')) {
		$default_style = $mhmm_styles[get_theme_mod('mhmm_style')];
		$style_options = array_merge(array('default' => 'Default (' . $default_style . ')'), $mhmm_styles);		
	}
	else {
		$style_options = array_merge(array('default' => 'Default'), $mhmm_styles);
	} ?>
	<select name="meta-mhmm-style">				
		<?php foreach($style_options as $value => $text) {
	        if($value == get_post_meta($object->ID, "meta-mhmm-style", true)) { ?>
	            <option value="<?=$value;?>" selected><?php echo $text; ?></option>
	        <?php }
	        else { ?>
	            <option value="<?=$value;?>" ><?php echo $text; ?></option>
			<?php }
	   	} ?>
   	</select>
    <?php
}

function add_mhmm_meta_box() {
	if ( function_exists('et_pb_is_allowed') && et_pb_is_allowed( 'divi_library' ) ) {
		add_meta_box('mhmm-meta-box', 'Mhmm', 'mhmm_meta_box_markup', '', 'side', 'low', null);
    }
}
add_action('add_meta_boxes', 'add_mhmm_meta_box');

function save_mhmm_meta_box($post_id, $post, $update) {
    if (!isset($_POST["mhmm-nonce"]) || !wp_verify_nonce($_POST["mhmm-nonce"], basename(__FILE__)))
        return $post_id;

    if(!current_user_can("edit_post", $post_id))
        return $post_id;

    if(defined("DOING_AUTOSAVE") && DOING_AUTOSAVE)
        return $post_id;
    
    // Update meta
    if(isset($_POST["meta-mhmm-header"])) {
        $meta_mhmm_header = $_POST["meta-mhmm-header"];
        update_post_meta($post_id, "meta-mhmm-header", $meta_mhmm_header);
    }   

    if(isset($_POST["meta-mhmm-style"])) {
        $meta_mhmm_style = $_POST["meta-mhmm-style"];
        update_post_meta($post_id, "meta-mhmm-style", $meta_mhmm_style);
    }    
}

add_action("save_post", "save_mhmm_meta_box", 10, 3);

add_filter( 'body_class','mhmm_body_classes' );
function mhmm_body_classes( $classes ) {
	global $post;
	if(isset($post)) {
		if(get_post_meta($post->ID, "meta-mhmm-style", true) && get_post_meta($post->ID, "meta-mhmm-style", true) != 'default') {
			$classes[] = get_post_meta($post->ID, "meta-mhmm-style", true);
		}
		else {
	    	$classes[] = get_theme_mod('mhmm_style');
	    }
	    return $classes;
    }
}

function mhmm_enqueue() {
	// Menu CSS
	wp_enqueue_style('mhmm-menus', plugins_url( '/css/mhmm-menus.css', __FILE__ ));

	// Header CSS and JS
	// WooCommerce support
	if(function_exists('is_shop') && is_shop()) {
    	$pageId = get_option( 'woocommerce_shop_page_id' );
    }
    else {
    	$pageId = get_queried_object_id();
    }	
	if(get_post_meta($pageId, "meta-mhmm-header", true) && get_post_meta($pageId, "meta-mhmm-header", true) != 'default') {
		$header_id = get_post_meta($pageId, "meta-mhmm-header", true);
	}
	else if(get_theme_mod('mhmm_layout')) {
		$header_id = get_theme_mod('mhmm_layout');
	}
	if($header_id && get_page_template_slug() != 'page-template-blank.php') {
		if($header_id != 'disabled') {
			$content_post = get_post($header_id);
			$content = $content_post->post_content;
			$html = do_shortcode($content);
		}
		else {
			$html = '';
		}
	    wp_enqueue_script('mhmm', plugins_url( '/js/mhmm.min.js', __FILE__ ), array('jquery'));
	    wp_localize_script( 'mhmm', 'html', $html );
	    wp_enqueue_style('mhmm', plugins_url( '/css/mhmm.css', __FILE__ ));
    }   
}
add_action( 'wp_enqueue_scripts', 'mhmm_enqueue' );

function mhmm_update_customizer( $postid ) {
	global $post_type;
	if($post_type == 'et_pb_layout') {
		// Remove theme customizer setting if selected layout is deleted
		if(has_term('mhmm_headers', 'layout_category', $postid)) {
			if(get_theme_mod('mhmm_layout') == $postid) {
				remove_theme_mod('mhmm_layout');
			}
		}
    }
}
add_action( 'wp_trash_post', 'mhmm_update_customizer' );

function mhmm_admin_enqueue() {
    // CSS
	wp_enqueue_style('mhmm-admin', plugins_url( '/css/mhmm-admin.css', __FILE__ ));	

	// JS
	global $post;
	wp_enqueue_script('mhmm-admin', plugins_url( '/js/mhmm-admin.min.js', __FILE__ ), array('jquery'));
    wp_localize_script( 'mhmm-admin', 'mhmm_admin_data', array('admin_url' => get_admin_url(null, '/customize.php?et_customizer_option_set=theme')));
}
add_action( 'admin_enqueue_scripts', 'mhmm_admin_enqueue' );

// Intialize these custom modules if the Builder is being used
add_action( 'et_builder_ready', 'Mhmm_Custom_Modules');

function Mhmm_Custom_Modules(){
    if(class_exists("ET_Builder_Module")){
       include("mhmm-menu-module.php");
       include("mhmm-inline-menu-module.php");
       include("mhmm-menu-layout-module.php");
    }
}

//=====  API LICENSING ========
if ( ! class_exists( 'superfly_mhmm_license' ) ) {
	require_once( plugin_dir_path( __FILE__ ) . 'superfly-mhmm-license-menu.php' );
	superfly_mhmm_license::instance( __FILE__, 'Mighty Header & Menu Maker', '1.4.5', 'plugin', 'https://besuperfly.com/' );
}

// Make it harder to find latest version. Keeps the honest people honest.
$updater = base64_decode('aHR0cHM6Ly9iZXN1cGVyZmx5LmNvbS90aGVtZXMtcGx1Z2lucy11cGRhdGVyL3BhY2thZ2VzL21obW0vbWhtbS5qc29u');

require 'plugin-update-checker/plugin-update-checker.php';
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    $updater,
    __FILE__,
    'mhmm'
);